@extends('admin/layout/master')
@section('title','Dashboard')
@section('content')

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Profile</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                        <li class="breadcrumb-item active">Profile</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div class="row">
                        <div class="col-md-8 offset-md-2">
                            <div class="card">
                                <div class="card-body">

            @if(count($errors) > 0)
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    <form action="{{ route('admin.profile.update') }}" method="post">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="fullname" class="form-label">Full Name</label>
            <input type="text" name="fullname" class="form-control" id="fullname" placeholder="Enter Full Name" value="{{$adminArr->full_name}}" required>
        </div>

        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" name="username" class="form-control" id="username" placeholder="Enter username" value="{{$adminArr->user_name}}" required>
        </div>

        <div class="mb-3">
            <label class="form-label" for="password-input">Password</label>
            <div class="position-relative auth-pass-inputgroup mb-3">
                <input type="password" name="password" class="form-control pe-5" placeholder="Enter new password" id="password-input" required>
                <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted" type="button" id="password-addon">
                    <i class="ri-eye-fill align-middle"></i>
                </button>
            </div>
        </div>
        <div class="mb-3">
            <label class="form-label" for="password-input">Confirm Password</label>
            <div class="position-relative auth-pass-inputgroup mb-3">
                <input type="password" name="password_confirmation" class="form-control pe-5" placeholder="Confirm password" id="password-input" required>
                <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted" type="button" id="password-addon">
                    <i class="ri-eye-fill align-middle"></i>
                </button>
            </div>
        </div>

        <div class="mb-3">
            <label for="company" class="form-label">Company Name</label>
            <input type="text" name="company" class="form-control" id="company" placeholder="Enter Full Name" value="{{$adminArr->company}}" required>
        </div>

        <div class="mt-5">
            <button class="btn btn-success w-100" type="submit">Update</button>
        </div>
    </form>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(session('fail'))
        <div class="alert alert-danger">{{ session('fail') }}</div>
    @endif

    </div>
                            </div>
                        </div>

</div>



@endsection
