@extends('master')
@section('title','Upbound')

@section('meta_description','Award-Winning Web Design & Website Development Company. Full-stack Web Agency With Highly Experienced WordPress Developers, Coders, SEO experts & Designers')

@section('content')
<?php

$fb = "https://fb.me/upbound.studio";
$insta = "https://www.instagram.com/upbound.studio/";
$linkedin = "https://www.linkedin.com/company/upbound-studio/";
$twitter = "#";
$behance = "https://www.behance.net/jackwisley";
$youtube = "https://www.youtube.com/channel/UCrww2Wj4P2QVWPEfjcFAiow";
$contactEmail = "hello@upbound.studio";
$careersEmail = $contactEmail;
$contactPhone =  "+447380527304";
$contactPhone2=  "+1 (252) 365 5117";
$contactPhoneFriendly = "+44(7380) 527 304";
$contactPhoneFriendly2 = "+1 (252) 365 5117";

?>
<div class="homepage">
    <section class="header main-section">
        <a href="/" class="logo"></a>
        <h1 class="hidden">Upbound Studio</h1>
        <ul class="social fixed desktop">
    <li>
        <a href="<?= $fb ?>" target="_blank">
            <i class="fa fa-facebook"></i>
        </a>
    </li>
    <!-- <li>
        <a href="#" target="_blank">
            <i class="fa fa-twitter"></i>
        </a>
    </li> -->
    <li>
        <a href="<?= $insta ?>" target="_blank">
            <i class="fa fa-instagram"></i>
        </a>
    </li>
    <li>
        <a href="<?= $behance ?>" target="_blank">
            <i class="fa fa-behance"></i>
        </a>
    </li>
    <li>
        <a href="<?= $youtube ?>" target="_blank">
            <i class="fa fa-youtube-play"></i>
        </a>
    </li>
    <li>
        <a href="<?= $linkedin ?>" target="_blank">
            <i class="fa fa-linkedin"></i>
        </a>
    </li>
</ul>        <a href="#" class="scroll-down"></a>
        <div class="circle-container-1 circle-container">
            <div class="bg bg-1 animate-this"></div>
        </div>
        <div class="circle-container-2 circle-container">
            <div class="bg bg-2 animate-this"></div>
        </div>
        <div class="circle-container-3 circle-container">
            <div class="bg bg-3 animate-this"></div>
        </div>
    </section>

    <section class="intro scroll-to main-section">
        <div class="mobile-menu-container mobile">
            <a href="#" class="open-mobile-menu">
                <span></span>
            </a>
        </div>
        <div class="container-left">
            <h2 class="add-fade-from-bottom">We create experiences &amp; customer journeys</h2>
            <p>We allow you to focus on your business while we keep the gears running smoothly in the background.</p>
            <a href="about" class="btn yellow">About us</a>
        </div>
        <div class="container-right">
            <div class="img-block">
                <figure></figure>
            </div>
        </div>
    </section>

    <section class="about main-section">
        <div class="background"></div>
        <div class="container-left">
            <p class="add-fade-in">We provide bespoke solutions that bridge the gap between commercial possibilities and creative resolution, while delivering effectiveness for our clients.</p>
            <figure class="desktop"></figure>
        </div>
        <div class="container-right">
            <ul>
                @foreach($serviceArr as $key => $service )
                <li class="add-push-title-up">
                    <i>{{$loop->iteration}}</i>
                    <h3>{{$service->service_name}}</h3>
                </li>
                @endforeach
            </ul>
            <p>Whatever the challenge, we always deliver a solution to help you Stand Out !</p>
            <a href="services" class="btn white medium">Our Services</a>
        </div>
    </section>

    <section class="work main-section">
        <h2>Case Studies</h2>
        <p class="subtitle">Explore our in-depth case studies showcasing successful collaborations and innovative solutions.</p>

        <ul class="custom-navigation carousel projects-carousel add-fade-from-bottom" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "swipeToSlide": true, "touchThreshold" : 10, "infinite": true, "arrows": true, "autoplay": true, "autoplaySpeed": 1500, "responsive": [{"breakpoint": 960, "settings": {"slidesToShow": 1}}]}'>
                   
                @foreach($portfolioArr as $portfolio)    
                @php 
                    $slug = str_replace(' ', '-', $portfolio->name);
                @endphp        
                <li>
                    <a href="{{Route('caseStudies.details',[$slug])}}" style="background: url('assets/images/portfolios/{{$portfolio->image}}') no-repeat center; background-size: cover">
                        <div class="overlay">
                            <h3>{{$portfolio->name}}</h3>
                            <span></span>
                            <figure><p>View Case Study<i></i></p></figure>
                        </div>
                    </a>
                </li>
                @endforeach
                            <
                    </ul>
        <div class="carousel-navigation">
            <a href="case-studies" class="more">View All Case Studies</a>
            <div>
                <a href="#" class="navigate prev" data-direction="prev"></a>
                <a href="#" class="navigate next" data-direction="next"></a>
            </div>
        </div>
    </section>

    <section class="work main-section">
        <h2>Portfolios</h2>
        <p class="subtitle">The brands we’ve worked with aren’t trophies, they’re friends we met on our journey.</p>

        <ul class="custom-navigation carousel projects-carousel add-fade-from-bottom" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "swipeToSlide": true, "touchThreshold" : 10, "infinite": true, "arrows": true, "autoplay": true, "autoplaySpeed": 1500, "responsive": [{"breakpoint": 960, "settings": {"slidesToShow": 1}}]}'>
                   
                @foreach($portfolioAdditionArr as $portfolio)    
                @php 
                    $slug = str_replace(' ', '-', $portfolio->name);
                @endphp        
                <li>
                    <a href="{{Route('portfolios.details',[$slug])}}" style="background: url('assets/images/portfoliosaddition/{{$portfolio->image}}') no-repeat center; background-size: cover">
                        <div class="overlay">
                            <h3>{{$portfolio->name}}</h3>
                            <span></span>
                            <figure><p>View Portfolio<i></i></p></figure>
                        </div>
                    </a>
                </li>
                @endforeach
                            <
                    </ul>
        <div class="carousel-navigation">
            <a href="portfolios" class="more">View All Portfolios</a>
            <div>
                <a href="#" class="navigate prev" data-direction="prev"></a>
                <a href="#" class="navigate next" data-direction="next"></a>
            </div>
        </div>
    </section>

    <section class="clients main-section">
        <ul class="clients-list">
            <li>
                <a style="background: url('assets/images/rolex_logo.png') no-repeat center; background-size: contain"></a>
            </li>
            <li>
                <a style="background: url('assets/images/apple.png') no-repeat center; background-size: contain"></a>
            </li>
            <li>
                <a style="background: url('assets/images/ministry-logo.png') no-repeat center; background-size: contain"></a>
            </li>
            <li>
                <a style="background: url('assets/images/unicef.png') no-repeat center; background-size: contain"></a>
            </li>
        </ul>

        <ul class="testimonials carousel add-fade-from-bottom" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "swipeToSlide": true, "touchThreshold" : 10, "infinite": true, "arrows": true, "autoplay": true, "autoplaySpeed": 3000}'>
    @foreach($testimonialArr as $testimonial)
    <li>
        <i>“</i>
        <p>{{$testimonial->msg}}</p>
        <h3>{{$testimonial->name}}</h3>
        <span>{{$testimonial->title}}</span>
        <figure style="background: url('assets/images/testimonials/{{$testimonial->img}}') no-repeat center; background-size: cover"></figure>
    </li>
    @endforeach
    
</ul>    </section>

    <section class="call-to-action main-section style-1">
        <div class="container-left">
            <div class="img-block">
                <figure class="desktop"></figure>
            </div>
        </div>
        <div class="container-right">
            <p>Want to work with us?</p>
            <h2 class="add-fade-from-bottom">We’d love to be your partner</h2>
            <a href="contact" class="btn yellow large">Get in Touch</a>
        </div>
    </section>
    <section class="awards main-section">
    <div class="content">
        <div>
            <h2>Awards</h2>
            <p>We are humbled and honored by the recognition from our peers</p>
        </div>
        <ul>
            <li class="cannes">
                <figure style="background: url('/origin/assets/images/cannes-lions-1.png') no-repeat center; background-size: contain"></figure>
            </li>
            <li class="awwards">
                <figure style="background: url('/origin/assets/images/awwards.png') no-repeat center; background-size: contain"></figure>
            </li>
            <li class="adesign">
                <figure style="background: url('/origin/assets/images/adesign-award.png') no-repeat center; background-size: contain"></figure>
            </li>
        </ul>
    </div>
</section></div>


@endsection
