@extends('admin.layout.master')
@section('title','Blogs')

@section('content')
	

							<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0">Blogs</h4>

            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                    <li class="breadcrumb-item active">Blogs</li>
                </ol>
            </div>

        </div>
    </div>
</div>
<!-- end page title -->
				<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Blogs Record</h4>
                 </div><!-- end card header -->

            <div class="card-body">
                
                <div class="live-preview">
                    <div class="table-responsive">
                        <table class="table align-middle table-nowrap mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
									<th>Image</th>
                                    <th>Title</th>
                                    <th>Post By</th>
									<th>Date</th>
									<th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($blogArr as $blog)
								<tr>
									<td>{{$blog->blog_id}}</td>
									<td><img src="assets/images/blogs/{{$blog->img}}" width="50px"></td>
                                    <td>{{$blog->title}}</td>
                                    <td>{{$blog->post}}</td>
									<td>{{$blog->date}}</td>
									<td>
										<div class="hstack gap-3 flex-wrap">
                                            <a href="{{Route('blogs.edit',[$blog->blog_id])}}" class="link-success fs-20"><i class="ri-edit-2-line"></i></a>

                                                    <form action="{{Route('blogs.destroy',[$blog->blog_id])}}" method="post">
														@csrf
														@method("DELETE")
														
													<button  onclick="return checkdelete()" type="submit" class="link-danger btn-delete"><i class="ri-delete-bin-line"></i></button>
													</form>
                                        </div>
									</td>
                                </tr>
                            @endforeach
                               
                            </tbody>
                        
                        </table>
                        <!-- end table -->
                    </div>
                    <!-- end table responsive -->
                </div>
                <div class="d-none code-view">

                </div>
            </div><!-- end card-body -->
        </div><!-- end card -->
    </div><!-- end col -->
</div>


<script type="text/javascript">
  function checkdelete(){
  
    return confirm("Are you sure");
  }
</script>

@endsection
