<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Livi_Shop_Metabox_Single_Upsell_Related' ) ) {
    class Livi_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'livi_shop_product_custom_settings', array( $this, 'livi_shop_product_custom_settings' ), 10 );

		}

        function livi_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('livi_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'livi'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'livi' ),
							'true'         => esc_html__( 'Show', 'livi'),
							null           => esc_html__( 'Hide', 'livi'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'livi'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'livi' ),
						1              => esc_html__( 'One Column', 'livi' ),
						2              => esc_html__( 'Two Columns', 'livi' ),
						3              => esc_html__( 'Three Columns', 'livi' ),
						4              => esc_html__( 'Four Columns', 'livi' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'livi'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'livi' ),
						1              => esc_html__( 'One', 'livi' ),
						2              => esc_html__( 'Two', 'livi' ),
						3              => esc_html__( 'Three', 'livi' ),
						4              => esc_html__( 'Four', 'livi' ),
						5              => esc_html__( 'Five', 'livi' ),
						6              => esc_html__( 'Six', 'livi' ),
						7              => esc_html__( 'Seven', 'livi' ),
						8              => esc_html__( 'Eight', 'livi' ),
						9              => esc_html__( 'Nine', 'livi' ),
						10              => esc_html__( 'Ten', 'livi' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'livi'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'livi' ),
							'true'         => esc_html__( 'Show', 'livi'),
							null           => esc_html__( 'Hide', 'livi'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'livi'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'livi' ),
						2              => esc_html__( 'Two Columns', 'livi' ),
						3              => esc_html__( 'Three Columns', 'livi' ),
						4              => esc_html__( 'Four Columns', 'livi' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'livi'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'livi' ),
						1              => esc_html__( 'One', 'livi' ),
						2              => esc_html__( 'Two', 'livi' ),
						3              => esc_html__( 'Three', 'livi' ),
						4              => esc_html__( 'Four', 'livi' ),
						5              => esc_html__( 'Five', 'livi' ),
						6              => esc_html__( 'Six', 'livi' ),
						7              => esc_html__( 'Seven', 'livi' ),
						8              => esc_html__( 'Eight', 'livi' ),
						9              => esc_html__( 'Nine', 'livi' ),
						10              => esc_html__( 'Ten', 'livi' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

Livi_Shop_Metabox_Single_Upsell_Related::instance();