<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'LiviPlusSiteToTop' ) ) {
    class LiviPlusSiteToTop {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            $this->load_modules();
            $this->frontend();
        }

        function load_modules() {
            include_once LIVI_PLUS_DIR_PATH.'modules/site-to-top/customizer/index.php';
        }

        function frontend() {
            $show = livi_customizer_settings('show_site_to_top');
            if( $show ) {
                add_filter( 'body_class', array( $this, 'add_body_classes' ) );
                add_action( 'livi_after_main_css', array( $this, 'enqueue_assets' ) );
                add_action( 'wp_footer', array( $this, 'load_template' ), 999 );
            }
        }

        function add_body_classes( $classes ) {
            $classes[] = 'has-go-to-top';
            return $classes;
        }

        function enqueue_assets() {
            wp_enqueue_style( 'site-to-top', LIVI_PLUS_DIR_URL . 'modules/site-to-top/assets/css/totop.css', false, LIVI_PLUS_VERSION, 'all' );
            wp_enqueue_script( 'go-to-top', LIVI_PLUS_DIR_URL . 'modules/site-to-top/assets/js/go-to-top.js', array('jquery'), LIVI_PLUS_VERSION, true );
        }

        function load_template() {
            $args = array(
                'icon' => '<span class="sroll-to-tap-icon"><svg fill="currentcolor" height="800px" width="800px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 511.999 511.999" xml:space="preserve">
<g><g><g><path d="M381.244,253.933v-5.92c12.135-1.988,23.302-7.763,32.037-16.709c10.64-10.896,16.501-25.286,16.501-40.517c0-15.233-5.86-29.623-16.501-40.518c-8.735-8.945-19.901-14.72-32.037-16.708v-5.92c0-15.671-12.75-28.421-28.421-28.421h-88.849V79.698c18.318-3.769,32.137-20.019,32.137-39.437C296.112,18.062,278.05,0,255.851,0c-22.2,0-40.26,18.062-40.26,40.261c0,19.418,13.818,35.668,32.136,39.437v19.523h-88.849c-15.672,0-28.421,12.75-28.421,28.421v5.963c-12.022,2.032-23.076,7.792-31.739,16.664c-10.64,10.896-16.501,25.286-16.501,40.518c0,15.232,5.86,29.622,16.501,40.517c8.664,8.872,19.718,14.631,31.739,16.664v5.963c0,15.671,12.75,28.421,28.421,28.421h88.849v20.4h-45.402c-24.434,0-44.312,19.878-44.312,44.311v52.188h-23.38c-15.672,0-28.42,12.75-28.42,28.42v76.203c0,4.487,3.636,8.124,8.124,8.124h51.801h119.144c4.488,0,8.124-3.637,8.124-8.124c0-4.487-3.636-8.124-8.124-8.124H174.26v-87.855v-60.831c0-15.474,12.589-28.063,28.064-28.063h107.054c15.474,0,28.063,12.589,28.063,28.063v60.832v87.855h-25.624c-4.488,0-8.124,3.637-8.124,8.124s3.636,8.124,8.124,8.124h33.748h51.799c4.488,0,8.124-3.637,8.124-8.124v-76.203c0-15.671-12.75-28.42-28.422-28.42h-23.377v-52.188c0-24.434-19.878-44.311-44.311-44.311h-45.403v-20.4h88.849v0.001C368.496,282.354,381.244,269.604,381.244,253.933z M381.244,150.093c18.656,4.245,32.291,20.758,32.291,40.695c0,19.936-13.636,36.447-32.291,40.694V150.093z M130.456,231.409c-18.5-4.356-31.992-20.791-31.992-40.621s13.492-36.266,31.992-40.621V231.409z M158.012,495.752h-35.552v-68.078c0-6.712,5.461-12.172,12.172-12.172h23.38V495.752zM353.689,415.501h23.377c6.713,0,12.173,5.461,12.173,12.172v68.078h-35.55V415.501z M231.839,40.261c0-13.241,10.772-24.013,24.012-24.013c13.241,0,24.013,10.772,24.013,24.013c0,13.241-10.772,24.013-24.013,24.013C242.61,64.274,231.839,53.503,231.839,40.261z M158.877,266.105c-6.713,0-12.173-5.461-12.173-12.172v-10.927c0.23-0.757,0.351-1.55,0.351-2.356v-99.727c0-0.806-0.121-1.599-0.351-2.356v-10.926c0-6.712,5.461-12.172,12.172-12.172h193.948c6.712,0,12.172,5.461,12.172,12.172v12.388c-0.032,0.296-0.053,0.595-0.053,0.895v99.727c0,0.3,0.021,0.599,0.053,0.895v12.388c0,6.712-5.461,12.172-12.172,12.172H158.877z"/>
<path d="M233.375,169.927c0-15.36-12.498-27.857-27.86-27.857c-15.36,0-27.856,12.497-27.856,27.857c0,15.36,12.496,27.857,27.856,27.857C220.877,197.784,233.375,185.287,233.375,169.927z M205.514,181.536c-6.401,0-11.608-5.208-11.608-11.609s5.207-11.609,11.608-11.609c6.403,0,11.612,5.208,11.612,11.609S211.918,181.536,205.514,181.536z"/>
<path d="M306.187,142.07c-15.361,0-27.858,12.497-27.858,27.857c0,15.36,12.497,27.857,27.858,27.857c15.361,0,27.857-12.497,27.857-27.857C334.044,154.567,321.548,142.07,306.187,142.07z M306.187,181.536c-6.402,0-11.61-5.208-11.61-11.609s5.208-11.609,11.61-11.609c6.401,0,11.609,5.208,11.609,11.609S312.588,181.536,306.187,181.536z"/>
<path d="M284.795,211.991c-4.348-1.095-8.765,1.547-9.859,5.898c-2.463,9.8-11.255,16.645-21.377,16.645c-10.169,0-18.968-6.883-21.397-16.739c-1.073-4.356-5.477-7.019-9.832-5.944c-4.356,1.073-7.017,5.476-5.944,9.832c4.222,17.132,19.509,29.099,37.173,29.099c17.583,0,32.854-11.897,37.135-28.932C291.787,217.499,289.147,213.085,284.795,211.991z"/>
<path d="M255.287,350.709c-27.795,0-50.41,22.613-50.41,50.41c0,27.795,22.614,50.409,50.41,50.409c27.794,0,50.408-22.613,50.408-50.409C305.695,373.323,283.082,350.709,255.287,350.709z M255.287,435.28c-18.837,0-34.162-15.324-34.162-34.16c0-18.837,15.324-34.162,34.162-34.162c18.836,0,34.159,15.324,34.159,34.162C289.447,419.955,274.122,435.28,255.287,435.28z"/></g></g>
</g>
</svg></span>'
            );

            echo livi_get_template_part( 'site-to-top/layouts/', 'template', '', $args );
        }
    }
}

LiviPlusSiteToTop::instance();