<?php
use LiviElementor\Widgets\LiviElementorWidgetBase;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;

class Elementor_Header_Menu extends LiviElementorWidgetBase {

    public function get_name() {
        return 'wdt-header-menu';
    }

    public function get_title() {
        return esc_html__('Header Menu', 'livi-plus');
    }

    public function get_icon() {
		return 'eicon-header wdt-icon';
	}

    protected function register_controls() {

		$nav_menus = array( 0 => esc_html__('Select Menu', 'livi-plus')  );
		$menus     = wp_get_nav_menus();

		foreach ($menus as $menu ) {
			$nav_menus[$menu->term_id] = $menu->name;
		}

        $this->start_controls_section( 'wdt_section_general', array(
            'label' => esc_html__( 'General', 'livi-plus'),
        ) );
            $this->add_control( 'nav_type', array(
				'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__('Navigation Type', 'livi-plus'),
				'default' => 'primary-nav',
				'options' => array(
                    'primary-nav' => esc_html__('Primary Nav','livi-plus'),
                    'secondary-nav' => esc_html__('Secondary Nav','livi-plus')
                )
            ) );

            $this->add_control( 'nav_id', array(
				'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__('Choose Menu', 'livi-plus'),
				'default' => '0',
				'options' => $nav_menus
            ) );

            $this->add_responsive_control( 'align', array(
                'label'        => esc_html__( 'Alignment', 'livi-plus' ),
                'type'         => Controls_Manager::CHOOSE,
                'prefix_class' => 'elementor%s-align-',
                'options'      => array(
                    'left'   => array( 'title' => esc_html__('Left','livi-plus'), 'icon' => 'eicon-h-align-left' ),
                    'center' => array( 'title' => esc_html__('Center','livi-plus'), 'icon' => 'eicon-h-align-center' ),
                    'right'  => array( 'title' => esc_html__('Right','livi-plus'), 'icon' => 'eicon-h-align-right' ),
                )
            ) );
        $this->end_controls_section();

        $this->start_controls_section( 'wdt_section_typography', array(
        	'label'      => esc_html__( 'Menu', 'livi-plus' ),
			'tab'        => Controls_Manager::TAB_STYLE,
			'show_label' => false,
		) );

			$this->add_group_control( Group_Control_Typography::get_type(), array(
                'label'      => esc_html__( 'Menu Typography', 'livi-plus' ),
				'name'     => 'menu_typography',
				'selector' => '{{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li > a',
				'separator' => 'before',
			) );

			$this->add_group_control( Group_Control_Typography::get_type(), array(
                'label'      => esc_html__( 'Sub Menu Typography', 'livi-plus' ),
				'name'     => 'sub_menu_typography',
				'selector' => '{{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav li ul.sub-menu li > a',
				'separator' => 'before',
			) );

        $this->end_controls_section();

        $this->start_controls_section( 'wdt_section_color', array(
        	'label'      => esc_html__( 'Colors', 'livi-plus' ),
			'tab'        => Controls_Manager::TAB_STYLE,
			'show_label' => false,
		) );

			$this->add_control( 'menu_color', array(
				'label'     => esc_html__( 'Menu Color', 'livi-plus' ),
				'type'      => Controls_Manager::COLOR,
				'default' 	=> '',
				'selectors' => array( '{{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li > a' => 'color: {{VALUE}}' )
			) );

			$this->add_control( 'menu_hover_color', array(
				'label'     => esc_html__( 'Menu Hover Color', 'livi-plus' ),
				'type'      => Controls_Manager::COLOR,
				'default' 	=> '',
				'selectors' => array( '
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.focus > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li:focus > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li:hover > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li > a.focus,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li > a:focus,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li > a:hover,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current-menu-item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current-page-item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current-menu-ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current-page-ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current_menu_item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current_page_item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current_menu_ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li.current_page_ancestor > a' => 'color: {{VALUE}}' )
			) );

			$this->add_control( 'sub_menu_color', array(
				'label'     => esc_html__( 'Sub Menu Color', 'livi-plus' ),
				'type'      => Controls_Manager::COLOR,
				'default' 	=> '',
				'selectors' => array( '{{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav li ul.sub-menu li > a' => 'color: {{VALUE}}' )
			) );

			$this->add_control( 'sub_menu_hover_color', array(
				'label'     => esc_html__( 'Sub Menu Hover Color', 'livi-plus' ),
				'type'      => Controls_Manager::COLOR,
				'default' 	=> '',
				'selectors' => array( '
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.focus > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li:focus > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li:hover > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li > a.focus,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li > a:focus,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li > a:hover,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current-menu-item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current-page-item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current-menu-ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current-page-ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current_menu_item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current_page_item > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current_menu_ancestor > a,
                {{WRAPPER}} .wdt-header-menu .menu-container .wdt-primary-nav > li ul.sub-menu > li.current_page_ancestor > a' => 'color: {{VALUE}}' )
			) );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        extract($settings);

        if (!empty($nav_id)) {
            $menu_object = wp_get_nav_menu_object($nav_id);

            if (!$menu_object) {
                echo '<div class="menu-not-found">'.esc_html__('Menu not found or invalid menu ID.', 'lizza-lms-plus').'</div>';
                return;
            }
            
        } else {
            echo '<div class="menu-not-found">'.esc_html__('Menu not selected.', 'lizza-lms-plus').'</div>';
            return;
        }

        $nav_class = '';
        if($nav_type == 'secondary-nav') {
            $nav_class = 'wdt-secondary-nav';
        }

        $navigation = wp_nav_menu( array(
        	'menu'            => $nav_id,
			'container_class' => 'menu-container',
			'items_wrap'      => '<ul id="%1$s" class="%2$s" data-menu="'.esc_attr($nav_id).'"> <li class="close-nav"><a href="javascript:void(0);"></a></li> %3$s </ul> <span class="slide-underline"></span> <div class="sub-menu-overlay"></div>',
			'menu_class'      => 'wdt-primary-nav '.$nav_class,
			'link_before'     => '<span data-text="%1$s">',
			'link_after'      => '</span>',
            'walker'          => new Livi_Walker_Nav_Menu,
            'echo'            => false
        ) );

        $out = '<div class="wdt-header-menu" data-menu="'.esc_attr( $nav_id ).'">';

        	$out .= $navigation;

            if($nav_type == 'primary-nav') {
                $out .= '<div class="mobile-nav-container mobile-nav-offcanvas-right" data-menu="'.esc_attr( $nav_id ).'">';
                    $out .= '<a href="#" class="menu-trigger menu-trigger-icon" data-menu="'.esc_attr( $nav_id ).'">';
                        $out .= '<i></i>';
                        $out .= '<span>'.esc_html__('Menu', 'livi-plus').'</span>';
                    $out .= '</a>';
                    $out .= '<div class="mobile-menu" data-menu="'.esc_attr( $nav_id ).'"></div>';
                    $out .= '<div class="overlay"></div>';
                $out .= '</div>';
            }

        $out .= '</div>';

        echo livi_html_output($out);
    }

}