<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function show()
    {
        $id=session('upboundStudioServer')->id;

        $adminArr = admin::where('id',$id)->first();
        return view('admin.profile', compact('adminArr'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'fullname' => 'required',
            'username' => 'required',
            'password' => 'required|confirmed|min:8',
            "password_confirmation"=>"required",
            'company' => 'required',
        ]);

        
        $id=session('upboundStudioServer')->id;
        $user =admin::find($id);
        $user->full_name = $request->fullname;
        $user->user_name = $request->username;
        $user->password = Hash::make($request->password);
        $user->company = $request->company;
        $user->save();

        return redirect()->route('admin.profile')->with('success', 'Profile updated successfully');
    }
}

