<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use DB; 
use Illuminate\Validation\Rules\Password;
use Carbon\Carbon; 
use App\Models\admin; 
use Mail; 
use Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

class ForgetPasswordController extends Controller
{
    //
    public function submitForgetPasswordForm(Request $request){

    	$token = Str::random(64);
    	// return $token;
    	
    	$data = [
            'token' => $token,
        ];
    	
    	$youremail = 'info@upbound.studio';

    	$body='<h1>Forget Password</h1>';
    	$body.='<span>You can reset password from bellow link:</span>';
    	$body.='<a href="reset-password/'.$token.'">Reset Password</a>';

    	DB::table('password_resets')->insert([
          'email' => "info@upbound.studio", 
          'token' => $token, 
          'created_at' => Carbon::now()
        ]);

        $fromEmail = $request->input('email') && !preg_match("/[\r\n]/", $request->input('email')) ? $request->input('email') : $youremail;

    // Render the Blade view and obtain its HTML content
    $body = View::make('email.forgetPassword', $data)->render();

    // Set the "From" header for the mail function
    ini_set('sendmail_from', $fromEmail);

    // Use the obtained HTML content for the email body
    mail($youremail, 'Reset Password', $body);


    	
    	return view('auth.forgot-password');



          return back()->with('message', 'An email has been sent to info@upbound.studio. Please check your email.');


    }

     public function showResetPasswordForm($token) { 
             return view('forgetPasswordLink', ['token' => $token]);
          }


     public function submitResetPasswordForm(Request $request)
          {
              $request->validate([
                  "password"=> 'required',
                  'password_confirmation' => 'required|same:password'
              ]);
              $email="info@upbound.studio";
             
      
              $updatePassword = DB::table('password_resets')
                                  ->where([
                                    'email' => $email, 
                                    'token' => $request->token
                                  ])
                                  ->first();
      
              if(!$updatePassword){
                  return back()->withInput()->with('error', 'Invalid token!');
              }
      
              $user = admin::orderBy('id','desc')->update(['password' => Hash::make($request->password)]);
     
              DB::table('password_resets')->where(['email'=> $email])->delete();
      
              return redirect('/admin')->with('message', 'Your password has been changed!');
          }
}
