<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\contact;

class ContactController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $contactArr=contact::orderBy('id','desc')->get();
        return view('admin/contacts/view',compact('contactArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/contacts/add');
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $req=new contact;
        $req->country=$request->input('txtcountry');
        // $req->country_code=$request->input('txtcode');
        $req->phone=$request->input('txtphone');
        $req->location=$request->input('txtlocation');
        $req->address=$request->input('txtaddress');
        $req->save();
        return redirect()->route('contacts.index')->with('message','Contact Info Save Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $contactArr=contact::where('id','=',$id)->firstOrFail();
        return view('admin/contacts/edit',compact('contactArr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $req=contact::where('id','=',$id)->first();
        $req->country=$request->input('txtcountry');
        // $req->country_code=$request->input('txtcode');
        $req->phone=$request->input('txtphone');
        $req->location=$request->input('txtlocation');
        $req->address=$request->input('txtaddress');
        $req->save();
        return redirect()->route('contacts.index')->with('message','Contact Info Save Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        contact::destroy(array('id',$id));
        return redirect()->route('contacts.index')->with('message','Contact Delete Successfully');
    }
}
