<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\testimonial;
use App\Models\category;
use App\Models\portfolio;

class CaseStudyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $portfolioArr=portfolio::orderBy('id','desc')->get();
        return view('admin/casestudies/view',compact('portfolioArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categoryArr=category::all();
        return view('admin/casestudies/add',compact('categoryArr'));
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $date = date_create();
        $time = date_format($date, 'YmdHis');

        $req=new portfolio;
        $req->name=$request->input('txtname');
        $req->cat_id=$request->input('txtcategory');
        $req->content_one=$request->input('contentOne');
        $req->content_two=$request->input('contentTwo');
        $req->content_three=$request->input('contentThree');
        $req->content_four=$request->input('contentFour');
        $req->content_five=$request->input('contentFive');
        $req->content_six=$request->input('contentSix');
        if($request->hasfile('txtimg'))
        {
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image = $filename;
        }
        if($request->hasfile('coverImage'))
        {
            $file = $request->file('coverImage');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->cover_image = $filename;
        }
        if($request->hasfile('imageOne'))
        {
            $file = $request->file('imageOne');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_one = $filename;
        }
        if($request->hasfile('imageTwo'))
        {
            $file = $request->file('imageTwo');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_two = $filename;
        }
        if($request->hasfile('imageThree'))
        {
            $file = $request->file('imageThree');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_three = $filename;
        }
        if($request->hasfile('imageFour'))
        {
            $file = $request->file('imageFour');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_four = $filename;
        }
        if($request->hasfile('imageFive'))
        {
            $file = $request->file('imageFive');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_five = $filename;
        }
        if($request->hasfile('imageSix'))
        {
            $file = $request->file('imageSix');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_six = $filename;
        }
        $req->save();
        return redirect()->route('portfolios.index')->with('message','Portfolio Add Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categoryArr=category::all();
        $portfolioArr=portfolio::where('id','=',$id)->firstOrFail();
        return view('admin/casestudies/edit',compact('portfolioArr','categoryArr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $date = date_create();
        $time = date_format($date, 'YmdHis');
        $req=portfolio::where('id','=',$id)->first();;
        $req->name=$request->input('txtname');
        $req->cat_id=$request->input('txtcategory');
        $req->content_one=$request->input('contentOne');
        $req->content_two=$request->input('contentTwo');
        $req->content_three=$request->input('contentThree');
        $req->content_four=$request->input('contentFour');
        $req->content_five=$request->input('contentFive');
        $req->content_six=$request->input('contentSix');
        if($request->hasfile('txtimg'))
        {
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image = $filename;
        }
        if($request->hasfile('coverImage'))
        {
            $file = $request->file('coverImage');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->cover_image = $filename;
        }
        if($request->hasfile('imageOne'))
        {
            $file = $request->file('imageOne');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_one = $filename;
        }
        if($request->hasfile('imageTwo'))
        {
            $file = $request->file('imageTwo');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_two = $filename;
        }
        if($request->hasfile('imageThree'))
        {
            $file = $request->file('imageThree');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_three = $filename;
        }
        if($request->hasfile('imageFour'))
        {
            $file = $request->file('imageFour');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_four = $filename;
        }
        if($request->hasfile('imageFive'))
        {
            $file = $request->file('imageFive');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_five = $filename;
        }
        if($request->hasfile('imageSix'))
        {
            $file = $request->file('imageSix');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/portfolios/', $filename);
            $req->image_six = $filename;
        }
        $req->save();
        return redirect()->route('portfolios.index')->with('message','Portfolio Update Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        portfolio::destroy(array('id',$id));
        return redirect()->route('portfolios.index')->with('message','Portfolios Delete Successfully');
    }
}
