@extends('master')


@section('title','About Upbound Studio | Amazing Web and Mobile Applications Design')

@section('meta_description','Learn more about Upbound Studio, a leading mobile app and web design agency with a focus on user experience')



@section('content')
<?php

$fb = "https://fb.me/upbound.studio";
$insta = "https://www.instagram.com/upbound.studio/";
$linkedin = "https://www.linkedin.com/company/upbound-studio/";
$twitter = "#";
$behance = "https://www.behance.net/jackwisley";
$youtube = "https://www.youtube.com/channel/UCrww2Wj4P2QVWPEfjcFAiow";
$contactEmail = "hello@upbound.studio";
$careersEmail = $contactEmail;
$contactPhone =  "+447380527304";
$contactPhone2=  "1(302)403-0151";
$contactPhoneFriendly = "+44(738) 052 7304";
$contactPhoneFriendly2 = "+1(302) 403-0151";

?>


	<style>
	
/*accordion*/


.accordion {
  width: 94%;
  margin-top: 20px;
  background-color: #fff;
  box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
  text-align:left !important;
  
}

.font-size-18{
    font-size:18px;
     font-family:gilroy-light, Helvetica, Arial, sans-serif;
}

#show-groups {
  background-color: #f0f0f0;
  padding: 15px;
  width: 100%;
  text-align: left;
  border: none;
  cursor: pointer;
  font-weight: bold;
}

.group-list {
  display: none;
}

.group-heading {
  background-color: #fff;
  padding: 15px;
  width: 100%;
  text-align: left;
  border: none;
  cursor: pointer;
  font-weight: bold;
  font-size:18px;
      border-top: 1px solid #d7d7d7;
      font-family:gilroy-light, Helvetica, Arial, sans-serif;
}

.group-content {
  display: none;
  padding: 10px 15px;
  background-color: #f9f9f9;
  line-height: 1.6;
  color: #333;
}

.group-heading.active {
  background-color: #e0e0e0;
}


.custom-css-group-content p{
	margin:0px;
	cursor:pointer;
	padding:0px 5px;
}

.custom-css-group-content p:hover{
	background:#c7c7c7;
	
}

.fa-plus{
	float:right;
}

.fa-plus-rotated {
    transform: rotate(45deg);
}
/*accordion End*/
	</style>
<div class="about-page">
    <div class="mobile-menu-container fixed mobile">
        <a href="#" class="open-mobile-menu">
            <span></span>
        </a>
    </div>
    <section class="hero main-section">
        <div class="container">
            <h1 class="hidden">About</h1>
            <div class="container-left preload">
                <h3 class="fade-in-sequence in-view"><span>Ambition.</span> <span>Talent.</span> <span>Love.</span></h3>
                <h3 class="fade-in-sequence in-view"><span>Call it what you want.</span></h3>
                <h2 class="fade-in-sequence fade-from-bottom in-view"><span>We call it Upbound Studio.</span></h2>
                <p class="fade-in-sequence in-view">
                    <span>Upbound Studio is a brand strategy and marketing agency that brings brands and culture together. With a belief that culture drives commerce, we leverage shared values and ideas to inform strategy and design, creating experiences that inspire life and inspire action.</span>
                </p>
                <p class="fade-in-sequence in-view">
                    <span>Our specialty of connecting brand, culture, and commerce has earned us a reputation for doing award-winning work across multiple categories. Our work is driven by our mission and our mission is this… we exist to create things people love.</span>
                </p>
                <a href="contact" class="btn yellow">Contact us</a>
            </div>

            <ul class="social fixed desktop">
    <li>
        <a href="<?= $fb ?>" target="_blank">
            <i class="fa fa-facebook"></i>
        </a>
    </li>
    <li>
        <a href="<?= $twitter ?>" target="_blank">
            <i class="fa fa-twitter"></i>
        </a>
    </li>
    <li>
        <a href="<?= $insta ?>" target="_blank">
            <i class="fa fa-instagram"></i>
        </a>
    </li>
    <li>
        <a href="<?= $behance ?>" target="_blank">
            <i class="fa fa-behance"></i>
        </a>
    </li>
  
    <li>
        <a href="<?= $linkedin ?>" target="_blank">
            <i class="fa fa-linkedin"></i>
        </a>
    </li>
</ul>            <a href="#" class="scroll-down desktop"></a>
            <!-- <div class="container-right">
                <figure></figure>
            </div> -->
        </div>
    </section>

    <section class="values main-section scroll-to">
        <div class="container-left">
            <h2>The values that define us.</h2>
        </div>
        <div class="container-right collapsed animation">
            <ul class="push-up-sequence">
                <li class="creative">
                    <figure></figure>
                    <div>
                        <h3>Creative</h3>
                        <p>To us, creativity is problem solving, and we believe in solving the impossible. We never settle for the first, easiest, or quickest solution.</p>
                    </div>
                </li>
                <li class="bold">
                    <figure></figure>
                    <div>
                        <h3>Bold</h3>
                        <p>To make an impact in today's world, you have to be able to put yourself out there.</p>
                    </div>
                </li>
                <li class="transparent">
                    <figure></figure>
                    <div>
                        <h3>Transparent</h3>
                        <p>As a creative agency, we stand by complete honesty in every aspect of our relationship with you.</p>
                    </div>
                </li>
            </ul>
        </div>
    </section>
    
    <section class="team main-section add-fade-from-bottom">
        <h2>Our Team</h2>
        <p>We Are All Makers, In Love With The Same Thing.</p>
        <ul class="custom-navigation carousel" data-slick='{"slidesToShow": 4, "slidesToScroll": 1, "swipeToSlide": true, "touchThreshold" : 10, "infinite": true, "arrows": true, "autoplay": true, "autoplaySpeed": 3000, "responsive": [{"breakpoint": 1750, "settings": {"slidesToShow": 3}}, {"breakpoint": 1350, "settings": {"slidesToShow": 2}}, {"breakpoint": 960, "settings": {"slidesToShow": 1, "slidesToScroll": 1}}]}'>
            <!-- <li class="marwan-arban">
                <figure></figure>
                <h3>Marwan Arban</h3>
                <span>Managing Director</span>
            </li>
            <li class="aly-bassam">
                <figure></figure>
                <h3>Aly Bassam</h3>
                <span>Senior Designer</span>
            </li>
            <li class="ahmad-sheikh">
                <figure></figure>
                <h3>Ahmad Hassan</h3>
                <span>Senior Web Developer</span>
            </li>
            <li class="lara-haidamous">
                <figure></figure>
                <h3>Lara Haidamous</h3>
                <span>Copywriter</span>
            </li>
            <li class="kholod-zughbor">
                <figure></figure>
                <h3>Kholod Zughbor</h3>
                <span>Senior Designer</span>
            </li> -->
            <li class="amir-sheikh">
                <figure></figure>
                <h3>Dave Roger</h3>
                <span>Creative Director</span>
            </li>
            <li class="emerson-lopez">
                <figure></figure>
                <h3>Dave Patrick</h3>
                <span>Creating Head</span>
            </li>
            <li class="hayyan-aldela">
                <figure></figure>
                <h3>Greg Adams</h3>
                <span>Digital Business Consultant</span>
            </li>
            <!-- <li class="nour-sawma">
                <figure></figure>
                <h3>Nour Sawma</h3>
                <span>Senior Designer</span>
            </li> -->
        </ul>
        <div class="carousel-navigation">
            <div>
                <a href="#" class="navigate prev" data-direction="prev"></a>
                <a href="#" class="navigate next" data-direction="next"></a>
            </div>
        </div>
    </section>

    <section class="work main-section">
        <div class="container">
            <div class="img-block">
                <figure></figure>
            </div>
            <div class="text">
                <h2>Our Work</h2>
                <p>Take a look at what we've created and get inspired</p>
                <a href="case-studies" class="btn white">View Work</a>
            </div>
        </div>
    </section>

    <section class="clients main-section">
        <div class="animation-sequence-1">
            <h2>Our Clients</h2>
            <p>Brands we've worked with</p>
        </div>
        <ul class="clients-list animation-sequence-2">
            <li class="rolex">
                <figure></figure>
            </li>
            <li class="apple">
                <figure></figure>
            </li>
            <li class="ministry">
                <figure></figure>
            </li>
            <li class="unicef">
                <figure></figure>
            </li>
            <li class="audi">
                <figure></figure>
            </li>
            <li class="al-arkan">
                <figure></figure>
            </li>
            <li class="bbac">
                <figure></figure>
            </li>
            <li class="al-baraka">
                <figure></figure>
            </li>
            <li class="yeprem">
                <figure></figure>
            </li>
            <li class="cham">
                <figure></figure>
            </li>
            <li class="total">
                <figure></figure>
            </li>
            <li class="psg">
                <figure></figure>
            </li>
        </ul>

        <ul class="testimonials carousel add-fade-from-bottom" data-slick='{"slidesToShow": 1, "slidesToScroll": 1, "swipeToSlide": true, "touchThreshold" : 10, "infinite": true, "arrows": true, "autoplay": true, "autoplaySpeed": 3000}'>
    @foreach($testimonialArr as $testimonial)
    <li>
        <i>“</i>
        <p>{{$testimonial->msg}}</p>
        <h3>{{$testimonial->name}}</h3>
        <span>{{$testimonial->title}}</span>
        <figure style="background: url('assets/images/testimonials/{{$testimonial->img}}') no-repeat center; background-size: cover"></figure>
    </li>
    @endforeach
</ul>    </section>

    <section class="partners main-section">
        <div class="animation-sequence-1">
            <h2>Our Partners</h2>
            <p>These are the badges that complete our experience</p>
        </div>
        <ul class="animation-sequence-2">
            <li class="google">
                <figure></figure>
                <span>Google Ads Partner</span>
            </li>
            <li class="hubspot">
                <figure></figure>
                <span>Hubspot Partner</span>
            </li>
            <li class="facebook">
                <figure></figure>
                <span>Facebook Marketing Partner</span>
            </li>
            <li class="facebook-marketing">
                <figure></figure>
                <span>Facebook Blueprint<br />Digital Marketing Associate</span>
            </li>
            <li class="facebook-buying">
                <figure></figure>
                <span>Facebook Blueprint<br />Media Buying Professional</span>
            </li>
            <li class="facebook-media">
                <figure></figure>
                <span>Facebook Media<br />Planning Professional</span>
            </li>
        </ul>
    </section>

    <section class="call-to-action main-section style-1">
        <div class="container-left">
            <div class="img-block">
                <figure class="desktop"></figure>
            </div>
        </div>
        <div class="container-right">
            <p>Want to work with us?</p>
            <h2 class="add-fade-from-bottom">We’d love to be your partner</h2>
            <a href="contact" class="btn yellow large">Get in Touch</a>
        </div>
    </section>

    <section class="awards main-section">
    <div class="content">
        <div>
            <h2>Awards</h2>
            <p>We are humbled and honored by the recognition from our peers</p>
        </div>
        <ul>
            <li class="cannes">
                <figure style="background: url('assets/images/cannes-lions-1.png') no-repeat center; background-size: contain"></figure>
            </li>
            <li class="awwards">
                <figure style="background: url('assets/images/awwards.png') no-repeat center; background-size: contain"></figure>
            </li>
            <li class="adesign">
                <figure style="background: url('assets/images/adesign-award.png') no-repeat center; background-size: contain"></figure>
            </li>
        </ul>
    </div>
</section>
<section class="team main-section">
        <h2>FAQ</h2>
        
   
    <div class="accordion" id="accordion">
<div class="group">
   <button type="button" class="group-heading">Where are you located? Do I need to meet you in real life for my service or to discuss the project? <i class="fa fa-plus"></i></button>
   
   <div class="group-content custom-css-group-content">
      <div class="row">
         <div class="col-md-12 font-size-18">
            We don't need to meet you in real life as we carry out everything online. We work with all clients remotely. Our headquarters are located in the USA, but we are an international company because we have employees working from different countries of the world.
         </div>
      </div>
   </div>
</div>
<div class="group">
   <button type="button" class="group-heading">How long does the service delivery? <i class="fa fa-plus"></i></button>
   <div class="group-content custom-css-group-content">
      <div class="row">
         <div class="col-md-12 font-size-18">
            The delivery of the service can takes a minimum of 2 days for most services but our team always provides a timeline for the service before you place the order.
         </div>
      </div>
   </div>
</div>
<div class="group">
   <button type="button" class="group-heading">I don't want my designs to be shown anywhere. <i class="fa fa-plus"></i></button>
   <div class="group-content custom-css-group-content">
      <div class="row">
         <div class="col-md-12 font-size-18">
            We do not use your new designs anywhere without your explicit consent to be added to our public portfolio.
         </div>
      </div>
   </div>
</div>
<div class="group">
   <button type="button" class="group-heading">I am not satisfied with the service that was delivered. <i class="fa fa-plus"></i>
</button>
   <div class="group-content custom-css-group-content">
      <div class="row">
         <div class="col-md-12 font-size-18">
           Please check with team to find a solution. We do offer a money back guarantee for maximum satisfaction. You can go through our money back guarantee policy by  <a href="https://upbound.studio/money-back-policy" style="color: #1ea196; text-decoration: underline;">Clicking Here</a>.
         </div>
      </div>
   </div>
</div>
</div>
 </section>

    <div class="video-overlay">
        <div class="video-container">
            <a href="#" class="close">x</a>
            <iframe width="100%" height="100%" class="yt_player_iframe" src="https://www.youtube.com/embed/XeQ16XQwHWQ?enablejsapi=1&amp;version=3&amp;playerapiid=ytplayer" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
        </div>
    </div>
</div>
<script>
	$(document).ready(function(){
		 $(".group-content").hide();
    
    $(document).on("click",".group-heading",function(){
      // Close all other open group contents
      $(".group-content").not($(this).next(".group-content")).slideUp();
      $(".group-heading").not(this).removeClass("active");
      
      // Toggle the content visibility
      $(this).next(".group-content").slideToggle();
      
      // Toggle the active class for styling
      $(this).toggleClass("active");
      $(this).find("i").toggleClass("fa-plus-rotated");
    });
	});
	</script>
@endsection
