<!doctype html>
<html lang="en" data-layout="vertical" data-topbar="light" data-sidebar="dark" data-sidebar-size="lg" data-sidebar-image="none">

<head>

    <meta charset="utf-8" />
    <title>Upbound Studio Admin & Dashboard</title>
    <base href="<?php echo e(\URL::to('/')); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="admin_dashboard/assets/images/favicon.ico">

    <!-- Layout config Js -->
    <script src="admin_dashboard/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="admin_dashboard/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="admin_dashboard/assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="admin_dashboard/assets/css/app.min.css" rel="stylesheet" type="text/css" />
    <!-- custom Css-->
    <link href="admin_dashboard/assets/css/custom.min.css" rel="stylesheet" type="text/css" />

</head>

<body>

    <div class="auth-page-wrapper custom-page-wrapper pt-5">
        <!-- auth page bg -->
        <div class="auth-one-bg-position auth-one-bg" id="auth-particles">
            <!-- <div class="bg-overlay"></div> -->

            <!-- <div class="shape">
                <svg xmlns="http://www.w3.org/2000/svg" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1440 120">
                    <path d="M 0,36 C 144,53.6 432,123.2 720,124 C 1008,124.8 1296,56.8 1440,40L1440 140L0 140z"></path>
                </svg>
            </div> -->
        </div>

        <!-- auth page content -->
        <div class="auth-page-content">
            <div class="container">
                <!-- <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center mt-sm-5 mb-4 text-white-50">
                            <div>
                                <a href="index.html" class="d-inline-block auth-logo">
                                    <img src="admin_dashboard/assets/images/logo-light.png" alt="" height="20">
                                </a>
                            </div>
                            <p class="mt-3 fs-15 fw-medium">Upbound Studio Admin Dashboard</p>
                        </div>
                    </div>
                </div> -->
                <!-- end row -->

                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5">
                        <div class="card mt-4 custom-auth-card-container">

                            <div class="card-body p-5">
                                <div class="text-center mt-2">
                                    <h5 class="text-primary">Welcome Back !</h5>
                                    <p class="text-muted">Sign in to continue to Upbound Studio Dashboard.</p>
                                </div>
                                <div class="p-2 mt-4">
                                    <form action="<?php echo e(Route('admin.login')); ?>" method="post">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-3">
                                            <label for="username" class="form-label">Username</label>
                                            <input type="text" name="txtuser" class="form-control" id="username" placeholder="Enter username" required>
                                        </div>

                                        <div class="mb-3">
                                            
                                            <label class="form-label" for="password-input">Password</label>
                                            <div class="position-relative auth-pass-inputgroup mb-3">
                                                <input type="password" name="txtpass" class="form-control pe-5" placeholder="Enter password" id="password-input" required>
                                                <button class="btn btn-link position-absolute end-0 top-0 text-decoration-none text-muted" type="button" id="password-addon"><i class="ri-eye-fill align-middle"></i></button>
                                            </div>
                                        </div>

                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="" id="auth-remember-check">
                                            <label class="form-check-label" for="auth-remember-check">Remember me</label>
                                        </div>

                                        <div class="mt-5">
                                            <button class="btn btn-success w-100" type="submit">Sign In</button>
                                        </div>

                                        
                                    </form>
                                    <?php if(Session::has('fail')): ?>
                                        <div class="alert alert-danger"><?php echo e(Session::get('fail')); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->

                        <div class="mt-4 text-center">
                            <p class="mb-0 custom-color">Don't have an account ? <a href="javascript:void(0)" class="fw-semibold custom-color text-primary text-decoration-underline"> Signup </a> </p>
                        </div>

                    </div>
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end auth page content -->

        <!-- footer -->
        <footer class="footer">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="text-center">
                            <p class="mb-0 text-muted custom-color">&copy;
                                COPYRIGHT
                                <script>document.write(new Date().getFullYear())</script> ALL RIGHTS RESERVED <i class="mdi mdi-heart text-danger"></i>  UPBOUND STUDIO
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <!-- end Footer -->
    </div>
    <!-- end auth-page-wrapper -->

    <!-- JAVASCRIPT -->
    <script src="admin_dashboard/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="admin_dashboard/assets/libs/simplebar/simplebar.min.js"></script>
    <script src="admin_dashboard/assets/libs/node-waves/waves.min.js"></script>
    <script src="admin_dashboard/assets/libs/feather-icons/feather.min.js"></script>
    <script src="admin_dashboard/assets/js/pages/plugins/lord-icon-2.1.0.js"></script>
    <script src="admin_dashboard/assets/js/plugins.js"></script>

    <!-- particles js -->
    <script src="admin_dashboard/assets/libs/particles.js/particles.js"></script>
    <!-- particles app js -->
    <script src="admin_dashboard/assets/js/pages/particles.app.js"></script>
    <!-- password-addon init -->
    <script src="admin_dashboard/assets/js/pages/password-addon.init.js"></script>
</body>
</html><?php /**PATH C:\Users\Intrawide\Downloads\upbound_studio\resources\views/admin/login.blade.php ENDPATH**/ ?>