
<?php $__env->startSection('title','Blogs'); ?>
<?php $__env->startSection('content'); ?>
<!-- start page title -->
<div class="row">
   <div class="col-12">
      <div class="page-title-box d-sm-flex align-items-center justify-content-between">
         <h4 class="mb-sm-0">Blogs</h4>
         <div class="page-title-right">
            <ol class="breadcrumb m-0">
               <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
               <li class="breadcrumb-item active">Blogs</li>
            </ol>
         </div>
      </div>
   </div>
</div>
<!-- end page title -->
<div class="row">
   <div class="col-lg-12">
      <div class="card">
         <div class="card-header align-items-center d-flex">
            <h4 class="card-title mb-0 flex-grow-1">Blogs Details</h4>
         </div>
         <!-- end card header -->
         <div class="card-body">
            <form action="<?php echo e(Route('blogs.update',[$blogArr->blog_id])); ?>" method="post" enctype="multipart/form-data">
               <?php echo csrf_field(); ?>
               <?php echo method_field("PATCH"); ?>
               <!--end col-->
               <div class="row">
                  <div class="col-xxl-10 col-lg-10 col-md-10 mt-3">
                     <div>
                        <label for="placeholderInput" class="form-label">Title</label>
                        <input type="text" class="form-control" id="titleInput" value="<?php echo e($blogArr->title); ?>" placeholder="Title" name="txttitle" required onkeyup="generateSlug()">
                     </div>
                  </div>
                  <div class="col-xxl-2 col-lg-2 col-md-2 mt-3">
                     <div>
                        <label for="placeholderInput" class="form-label">Post By</label>
                        <input type="text" class="form-control" id="placeholderInput" value="<?php echo e($blogArr->post); ?>" placeholder="Post By" name="txtpost" required >
                     </div>
                  </div>
                  <div class="col-xxl-10 col-lg-10 col-md-10 mt-3" style="display:none;">
                     <div>
                        <label for="placeholderInput" class="form-label">Slug</label>
                        <input type="text" class="form-control" id="slugInput" placeholder="slug" name="slug" value="<?php echo e($blogArr->slug); ?>" required readonly>
                     </div>
                  </div>
                  <div class="col-xxl-6 col-lg-6 col-md-6 mt-3">
                     <div>
                        <label for="category" class="form-label">Category</label>
                        <select name="category_id" class="form-select" required>
                           <option value="">Select Category</option>
                           <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <option value="<?php echo e($category->cat_id); ?>" 
                           <?php echo e($blogArr->category_id == $category->cat_id ? 'selected' : ''); ?>>
                           <?php echo e($category->des); ?>

                           </option>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                     </div>
                  </div>
                  <div class="col-xxl-6 col-lg-6 col-md-6 mt-3">
                     <div>
                        <label for="placeholderInput" class="form-label">Meta Title</label>
                        <input type="text" class="form-control" id="meta_title" value="<?php echo e($blogArr->meta_title); ?>" placeholder="Title" name="meta_title">
                     </div>
                  </div>
                  <div class="col-xxl-12 col-md-12 mt-3">
                     <div>
                        <label for="placeholderInput" class="form-label">Image</label>
                        <input type="file" class="filepond filepond-input-multiple" multiple name="txtimg" data-allow-reorder="true" data-max-file-size="3MB" data-max-files="3">
                     </div>
                  </div>
                  <div class="col-xxl-12 col-md-12 mt-3">
                     <div>
                        <label for="placeholderInput" class="form-label">Description</label>
                        <textarea class="form-control" name="txtdes" placeholder="Description" rows="5" required><?php echo e($blogArr->des); ?></textarea>
                     </div>
                  </div>
                  <div class="col-xxl-12 col-md-12 mt-3">
            <div>
               <label for="metaDescriptionInput" class="form-label">Meta Description</label>
               <textarea class="form-control" name="meta_description" placeholder="Description" rows="6" ><?php echo e($blogArr->meta_description); ?></textarea>
            </div>
         </div>
                  <div class="col-xxl-12 col-md-12 mt-3">
                     <div class="text-center">
                        <button type="submit" class="btn btn-success btn-label"><i class="ri-check-double-line label-icon align-middle fs-16 me-2"></i> Save</button>
                     </div>
                  </div>
               </div>
               <!--end col-->
            </form>
         </div>
         <!--end row-->
      </div>
      <div class="d-none code-view">
         <pre class="language-markup" style="height: 450px;">
         <code>&lt;!-- Basic Input --&gt;
      </div>
   </div>
</div>
<script>
   function generateSlug() {
      let title = document.getElementById('titleInput').value;
      let slug = title
         .toLowerCase() 
         .trim() 
         .replace(/[\s\W-]+/g, '-')
         .replace(/^-+|-+$/g, ''); 

      document.getElementById('slugInput').value = slug;
   }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/upboltop/public_html/resources/views/admin/blogs/edit.blade.php ENDPATH**/ ?>