<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FrontController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\PortfolioController;
use App\Http\Controllers\CaseStudyController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ForgetPasswordController;
/*
|--------------------------------------------------------------------------
| Web Routes
|-------------------------------------------------------------------------- 
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


//Website
Route::fallback([FrontController::class, 'handle404']);

Route::view('lifetime-hosting','lifetime_hosting')->name('lifetime.hosting');
Route::view('graphic-detail','graphic-detail')->name('graphic-detail');
Route::view('web-detail','web-detail')->name('web-detail');
Route::view('mobile-detail','mobile-detail')->name('mobile-detail');
Route::view('marketing-detail','marketing-detail')->name('marketing-detail');
Route::view('virtual-detail','virtual-detail')->name('virtual-detail');
Route::get('/',[FrontController::class,'index']);
// Route::get('/index',[FrontController::class,'index']);
Route::get('/about',[FrontController::class,'aboutPage']);
Route::get('/contact',[FrontController::class,'contactPage']);
Route::get('/blog',[FrontController::class,'blogPage']);
Route::get('/blog-detail/{slug}', [FrontController::class, 'blogDetail'])->name('blog.detail');
Route::get('/services',[FrontController::class,'servicePage']);
Route::get('/service/{id}', [FrontController::class, 'servicesDetailPage'])->name('services.details');
Route::get('/privacy-policy',[FrontController::class,'privacyPolicyPage']);
Route::get('/money-back-policy',[FrontController::class,'moneyBackPolicyPage']);
Route::get('/case-studies',[FrontController::class,'caseStudiesPage']);
Route::get('/portfolios',[FrontController::class,'portfoliosPage']);
Route::post('/message/save',[FrontController::class,'store'])->name('message.save');
Route::view('/thank-you','thank_you')->name('Thank_you.page');
Route::get('/case-studies/{id}',[FrontController::class,'caseStudiesDetailPage'])->name('caseStudies.details');
Route::get('/portfolios/{id}',[FrontController::class,'portfoliosDetailPage'])->name('portfolios.details');


// Admin Dashboard
Route::get('/admin', function () {
    if (session()->has('upboundStudioServer')) {
            return redirect('admin/dashboard');
    }else{
        return view('admin/login');
    }
});

Route::post('admin/auth',[AdminController::class,'login'])->name('admin.login');
Route::get('/logout',[AdminController::class,'logout'])->name('admin.logout');



// Route::get('/forget-password', [ForgetPasswordController::class, 'forgetPasswordForm'])->name('forget.password.get');
Route::get('forget-password', [ForgetPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password');
Route::get('reset-password/{token}', [ForgetPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');
Route::post('reset-password', [ForgetPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');


Route::group(['middleware'=>['AdminCheckAuth']],function(){
	Route::view('/admin/dashboard','admin/index')->name('admin.index');
	Route::get('admin/profile', [ProfileController::class, 'show'])->name('admin.profile');
	// Route::get('admin/profile/edit', [ProfileController::class, 'edit'])->name('admin.profile.edit');
    Route::put('admin/profile/update', [ProfileController::class, 'update'])->name('admin.profile.update');
	Route::resource('admin/testimonials', TestimonialController::class);
	Route::resource('admin/services', ServiceController::class);
	Route::resource('admin/messages', MessageController::class);
	Route::resource('admin/category', CategoryController::class);
	Route::resource('admin/portfolios', CaseStudyController::class);
	Route::resource('admin/portfoliosaddition', PortfolioController::class);
	Route::resource('admin/contacts', ContactController::class);
	Route::resource('admin/blogs', BlogController::class);
});   
