@extends('admin.layout.master')
@section('title','Contact Info')

@section('content')
<!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Contact Info</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboards</a></li>
                                        <li class="breadcrumb-item active">Contact Info</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->
									<div class="row">
                        <div class="col-xl-12">
                            <div class="card">
                                <div class="card-header align-items-center d-flex">
                                    <h4 class="card-title mb-0 flex-grow-1">Contact Record</h4>
                                     </div><!-- end card header -->
                    
                                <div class="card-body">
                                    
                                    <div class="live-preview">
                                        <div class="table-responsive">
                                            <table class="table align-middle">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Country</th>
                                                        <th>Phone</th>
                                                        <th>Location</th>
                                                        <th>Address</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                		@foreach($contactArr as $contact)
                                                        <tr>
                                                            <td>{{$contact->id}}</td>
                                                            <td>{{$contact->country}}</td>
                                                            <td>{{$contact->country_code}} {{$contact->phone}}</td>
                                                            <td>
                                                                <iframe src="{{$contact->location}}"></iframe>
                                                            </td>
                                                            <td>{{$contact->address}}</td>
                                                            <td>
                                                                <div class="display-inline-flex pad-left-right-20">
                                                                <a href="{{Route('contacts.edit',[$contact->id])}}" class="link-success fs-20"><i class="ri-edit-2-line"></i></a>
                                                               
                                                                <form action="{{Route('contacts.destroy',[$contact->id])}}" method="post">
                                                                    @csrf
                                                                    @method("DELETE")
                                                                    <button  onclick="return checkdelete()" type="submit" class="link-danger btn-delete"><i class="ri-delete-bin-line"></i></button>
                                                                </form>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                            <!-- end table -->
                                        </div>
                                        <!-- end table responsive -->
                                    </div>
                                    <div class="d-none code-view">
                    
                                    </div>
                                </div><!-- end card-body -->
                            </div><!-- end card -->
                        </div><!-- end col -->
                    </div>


<script type="text/javascript">
  function checkdelete(){
  
    return confirm("Are you sure");
  }
</script>

@endsection
