document.addEventListener("DOMContentLoaded", function() {
    var lazyloadImages;
    if ("IntersectionObserver" in window) {
        lazyloadImages = document.querySelectorAll(".lazy");
        var imageObserver = new IntersectionObserver(function(entries, observer) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    var image = entry.target;
                    image.src = image.dataset.src;
                    image.classList.remove("lazy");
                    imageObserver.unobserve(image);
                }
            });
        });
        lazyloadImages.forEach(function(image) {
            imageObserver.observe(image);
        });
    } else {
        var lazyloadThrottleTimeout;
        lazyloadImages = document.querySelectorAll(".lazy");
        function lazyload () {
            if(lazyloadThrottleTimeout) {
                clearTimeout(lazyloadThrottleTimeout);
            }
            lazyloadThrottleTimeout = setTimeout(function() {
                var scrollTop = window.pageYOffset;
                lazyloadImages.forEach(function(img) {
                    if(img.offsetTop < (window.innerHeight + scrollTop)) {
                        img.src = img.dataset.src;
                        img.classList.remove('lazy');
                    }
                });
                if(lazyloadImages.length == 0) {
                    document.removeEventListener("scroll", lazyload);
                    window.removeEventListener("resize", lazyload);
                    window.removeEventListener("orientationChange", lazyload);
                }
            }, 20);
        }
        document.addEventListener("scroll", lazyload);
        window.addEventListener("resize", lazyload);
        window.addEventListener("orientationChange", lazyload);
    }
})


$(document).ready(function(){
    $('img').attr('loading','lazy');
    // Case Studies JS
    if($('.case-study').length > 0) {
        $('.case-study-page .case-study .text .container img').addClass('img-full').wrap('<div class="image-container"></div>');
        $(".image-container").unwrap();
    }
    /*
    if($('.case-study-page .page-header figure').length > 0) {
        var cw = $('.case-study-page .page-header figure').width();
        $('.case-study-page .page-header figure').css({'height':cw+'px'});
    } */
    // Case Studies JS END

    $('.carousel').each(function() {
        $(this).slick();
    });

    $('.carousel-navigation .navigate').click(function(e) {
        e.preventDefault();
        var this_button = $(this);
        if(this_button.hasClass('disabled')) return false;
        var direction = this_button.data('direction');
        var carousel = $(this).parents('.carousel-navigation').siblings('.carousel');
        var slick_navigator = carousel.find('.slick-' + direction);
        slick_navigator.trigger('click');
        carouselNavigationState(carousel);
    });

    $('.carousel.custom-navigation').on('swipe', function(event, slick, direction){
        var carousel = $(this);
        carouselNavigationState(carousel);
    });

    $('.scroll-down').on('click', function(e){
        e.preventDefault();
        $('html, body').animate({scrollTop: $(".scroll-to").offset().top}, 500);
    })

    $('.filter_items').on('click', function(e){
        e.preventDefault();
        $('.filter_items').removeClass('active');
        $(this).addClass('active');
        var filter = $(this).data('filter');
        if(filter == "") {
            $('.filtered_items').fadeIn();
        } else {
            $('.filtered_items').fadeOut();
            $('.filtered_items.'+filter+'').fadeIn();
        }
    })

    $(document).on("click", "a.to-top", function(e){
        e.preventDefault();
        $('html, body').animate({scrollTop: 0}, 500);
    });

    $('.scroll-to-contact').on('click', function(e){
        e.preventDefault();
        $('html, body').animate({scrollTop: $(".contact-page .contact").offset().top}, 500);
    })

    $('.open-mobile-menu').on('click', function(e){
        e.preventDefault();
        $('.main-menu').addClass('active');
        $('body').addClass('noscroll');
    })

    $('.close-menu').on('click', function(e){
        e.preventDefault();
        $('.main-menu').removeClass('active');
        $('body').removeClass('noscroll');
    })

    $(window).scroll(function () {
        if($('footer .bottom-section').length > 0){
            var footer = $('footer .bottom-section');
            var footer_offset = footer.offset().top;
        }
        if(!isMobile()){
            var limit = $(window).scrollTop();
            if(limit > 1200) $("a.to-top").fadeIn(500);
            else $("a.to-top").fadeOut(500);

            if($('.homepage section.about').length > 0){
                var homepage_about = $('.homepage section.about');
                var homepage_about_offset = homepage_about.offset().top;
            }
            if($('.about-page .values').length > 0){
                var values = $('.about-page .values');
                var values_offset = values.offset().top;
            }
            if($('.case-study-page').length > 0 && $('.case-study-page .case-study .text .carousel-container').length > 0){
                var carousel_container = $('.case-study-page .case-study .text .carousel-container');
                var carousel_container_offset = carousel_container.offset().top;
            }

            if($('header .fixed-menu .logo').length > 0){
                var logo = $('header .fixed-menu .logo');
                var logo_offset = logo.offset().top;
            }

            if($('.left-nav .open-mobile-menu').length > 0){
                var open_menu = $('.left-nav .open-mobile-menu');
                var open_menu_offset = open_menu.offset().top;
            }

            if($('.left-nav .copyrights').length > 0){
                var copyrights = $('.left-nav .copyrights');
                var copyrights_offset = copyrights.offset().top;
            }

            var contact = $('header .fixed-menu .contact');

            if($('.homepage').length > 0 || $('.about-page').length > 0){
                var contact_offset = contact.offset().top;
            }

            if($('.homepage').length > 0){
                if(logo_offset >= homepage_about_offset && logo_offset < homepage_about_offset + homepage_about.outerHeight()) logo.addClass('white');
                else logo.removeClass('white');

                if(contact_offset >= homepage_about_offset && contact_offset < homepage_about_offset + homepage_about.outerHeight()) contact.addClass('white');
                else contact.removeClass('white');

                if((open_menu_offset >= homepage_about_offset && open_menu_offset < homepage_about_offset + homepage_about.outerHeight()) || open_menu_offset >= footer_offset) open_menu.addClass('white');
                else open_menu.removeClass('white');

                if((copyrights_offset >= homepage_about_offset && copyrights_offset < homepage_about_offset + homepage_about.outerHeight()) || copyrights_offset >= footer_offset) copyrights.addClass('white');
                else copyrights.removeClass('white');

                var about_limit = limit + 1000;
                if(about_limit >= homepage_about_offset && about_limit <= homepage_about_offset + homepage_about.outerHeight() + 800){
                    var scroll_percentage = (about_limit - homepage_about_offset) / homepage_about.outerHeight() * 100;
                    $('.homepage section.about .background').css('width', scroll_percentage + '%').css('height', scroll_percentage + '%');
                }
            }

            if($('.about-page').length > 0){
                if(contact_offset >= values_offset && contact_offset < values_offset + values.outerHeight()) contact.addClass('white');
                else contact.removeClass('white');
            }

            if($('.case-study-page').length > 0){
                if(logo_offset >= carousel_container_offset && logo_offset < carousel_container_offset + carousel_container.outerHeight()) logo.addClass('white');
                else logo.removeClass('white');

                if((open_menu_offset >= carousel_container_offset && open_menu_offset < carousel_container_offset + carousel_container.outerHeight()) || (open_menu_offset >= footer_offset)) open_menu.addClass('white');
                else open_menu.removeClass('white');

                if((copyrights_offset >= carousel_container_offset && copyrights_offset < carousel_container_offset + carousel_container.outerHeight()) || (copyrights_offset >= footer_offset)) copyrights.addClass('white');
                else copyrights.removeClass('white');
            }

            if($('.homepage').length == 0 && $('.case-study-page').length == 0 && $('.landing-page').length == 0 && $('.thank-you-page-header').length == 0){
                if(open_menu_offset >= footer_offset) open_menu.addClass('white');
                else open_menu.removeClass('white');

                if(copyrights_offset >= footer_offset) copyrights.addClass('white');
                else copyrights.removeClass('white');
            }

        }
            else{
                if($('section.intro').length > 0){
                    var fixed_point = $('section.intro').offset().top;
                    if ($(window).scrollTop() >= fixed_point){
                        $(".mobile-menu-container").addClass('fixed');
                        $("section.intro").addClass('add-padding');
                    }
                        else{
                            $(".mobile-menu-container").removeClass('fixed');
                            $("section.intro").removeClass('add-padding');
                        }
                }

                if($('.mobile-menu-container .open-mobile-menu').length > 0) var open_mobile_menu = $('.mobile-menu-container.transparent .open-mobile-menu');
                if($('.case-study-page .case-study .text .carousel-container').length > 0) var carousel_container = $('.case-study-page .case-study .text .carousel-container');
                if($('.contact-page .locations').length > 0) var locations = $('.contact-page .locations');

                if($('.mobile-menu-container.transparent .open-mobile-menu').length > 0){
                    var open_mobile_menu_offset = open_mobile_menu.offset().top;
                    if(open_mobile_menu_offset >= footer_offset) open_mobile_menu.addClass('white');
                    else open_mobile_menu.removeClass('white');
                }

                if($('.case-study-page .case-study .text .carousel-container').length > 0){
                    var carousel_container_offset = carousel_container.offset().top;
                    if((open_mobile_menu_offset >= carousel_container_offset && open_mobile_menu_offset < carousel_container_offset + carousel_container.outerHeight()) || (open_mobile_menu_offset >= footer_offset)) open_mobile_menu.addClass('white');
                    else open_mobile_menu.removeClass('white');
                }

                if($('.contact-page .locations').length > 0){
                    var locations_offset = locations.offset().top;
                    if((open_mobile_menu_offset >= locations_offset && open_mobile_menu_offset < locations_offset + locations.outerHeight()) || (open_mobile_menu_offset >= footer_offset)) open_mobile_menu.addClass('white');
                    else open_mobile_menu.removeClass('white');
                }
            }

        if($('.services-page').length == 0){
            $(".img-block:in-viewport").each(function () {
                $(this).addClass('reveal');
            });
        }
            else{
                $(".services-page .services .service .info-container:in-viewport").each(function () {
                    $(this).siblings().find('.img-block').addClass('reveal');
                });
            }

        $(".add-fade-in:in-viewport").each(function () {
            $(this).addClass('fade-in');
        });

        $(".add-push-title-up:in-viewport").each(function () {
            $(this).addClass('push-title-up');
        });

        $(".add-fade-from-bottom:in-viewport").each(function () {
            $(this).addClass('fade-from-bottom');
        });

        $(".about-page .values .container-right:in-viewport").each(function () {
            $(this).removeClass('collapsed');
            addAnimationDelayed('.push-up-sequence', 'push-title-up', 500);
            setTimeout(function(){
                $('.about-page .values h2').addClass('fade-in');
            }, 2000);
        });

        $(".about-page .work .container .text:in-viewport").each(function () {
            addAnimationDelayed('.text', 'fade-in', 500);
        });

        $(".about-page .clients .animation-sequence-1:in-viewport").each(function () {
            addAnimationDelayed('.about-page .clients .animation-sequence-1', 'fade-in', 500);
            setTimeout(function(){
                addAnimationDelayed('.about-page .clients .animation-sequence-2', 'fade-in', 250);
            }, 1000);
        });

        $(".about-page .partners .animation-sequence-1:in-viewport").each(function () {
            addAnimationDelayed('.about-page .partners .animation-sequence-1', 'fade-in', 500);
            setTimeout(function(){
                addAnimationDelayed('.about-page .partners .animation-sequence-2', 'fade-in', 250);
            }, 1000);
        });

        $(".services-page .animation-sequence-1:in-viewport").each(function () {
            addAnimationDelayed($(this), 'fade-in', 400);
            var sibling = $(this).siblings('.animation-sequence-2');
            setTimeout(function(){
                addAnimationDelayed(sibling, 'push-title-up', 250);
            }, 1100);
        });

        $(".contact-page .locations .container .details:in-viewport").each(function () {
            $(this).removeClass('collapse').siblings().removeClass('collapse');
            setTimeout(function(){
                addAnimationDelayed($('.contact-page .locations .container .details .animation-sequence-1'), 'fade-in', 250);
            }, 500);
            setTimeout(function(){
                addAnimationDelayed($('.contact-page .locations .container .details .animation-sequence-2'), 'push-title-up', 250);
            }, 1000);
        });

        $(".contact-page .contact .animation-sequence-1:in-viewport").each(function () {
            addAnimationDelayed($(this), 'fade-in', 500);
            var sibling = $(this).siblings('.animation-sequence-2');
            setTimeout(function(){
                addAnimationDelayed(sibling, 'push-title-up', 250);
            }, 1000);
        });

    });

    if($('.fade-in-sequence.in-view').length > 0){
        addAnimationDelayed('.fade-in-sequence', 'fade-in', 500);
    }

    if($('.about-page .hero .img-block').length > 0){
        $('.about-page .hero .img-block').addClass('reveal');
    }

    if($('.case-studies-page .page-header.collapse-circles').length > 0){
        $('.case-studies-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.case-studies-page .page-header .title', 'fade-in', 600);
        }, 500);
        setTimeout(function(){
            $('.case-studies-page .scroll-down p.hide').css('transition', '1s');
            $('.case-studies-page .scroll-down p.hide').removeClass('hide');
        }, 2000);
    }

    if($('.services-page .page-header.collapse-circles').length > 0){
        $('.services-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.services-page .page-header .title', 'fade-in', 600);
        }, 750);
        setTimeout(function(){
            $('.services-page .scroll-down p.hide').css('transition', '1s');
            $('.services-page .scroll-down p.hide').removeClass('hide');
        }, 2250);
    }

    if($('.blog-page .page-header.collapse-circles').length > 0){
        $('.blog-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.blog-page .page-header .title', 'fade-in', 600);
        }, 750);
    }

    if($('.blog-post-page .page-header.collapse-circles').length > 0){
        $('.blog-post-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.blog-post-page .page-header .title', 'fade-in', 600);
        }, 750);
    }

    if($('.contact-page .page-header.collapse-circles').length > 0){
        $('.contact-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.contact-page .page-header .title', 'fade-in', 600);
        }, 500);
    }

    if($('.privacy-page .page-header.collapse-circles').length > 0){
        $('.privacy-page .page-header.collapse-circles').removeClass('collapse-circles');
        setTimeout(function(){
            addAnimationDelayed('.privacy-page .page-header .title', 'fade-in', 600);
        }, 500);
    }

    $(document).on('click', '.services-page .faq ul li a', function(e){
        e.preventDefault();
        var url = $(this).attr('href');
        if(url !== '#' && url !== '') {
            window.open(url, '_blank').focus();
        }
        return false;
    })

    $('.services-page .faq ul li').on('click', function(){
        $(this).toggleClass('active');
        $(this).find('.answer').slideToggle();
    });

    $('form .contact-services ul li').on('click', function(e){
        e.preventDefault();
        $(this).toggleClass('active');
        if($(this).hasClass('active')) $(this).find('input[type=checkbox]').prop('checked', true);
        else $(this).find('input[type=checkbox]').prop('checked', false);
    })

    $('header .fixed-menu .contact').on('click', function(e){
        e.preventDefault();
        $('.contact-overlay').fadeIn(350);
    })

    $('.contact-overlay form .close').on('click', function(e){
        e.preventDefault();
        $('.contact-overlay').fadeOut(350);
    })

    $('body').on('click', function(e){
        if($('.contact-overlay').length > 0) if($(e.target).attr('class') === 'contact-overlay') $('.contact-overlay').fadeOut(350);
    })

    if(!isMobile()){
        $('.contact-page .locations .container .details ul li h3').on('mouseenter', function(e){
            $(this).addClass('active');
            var country = $(this).data('country');
            $('.contact-page .locations .container .map i[data-country="' + country + '"]').addClass('active');
        }).on('mouseleave', function(e){
                var country = $(this).data('country');
                $('.contact-page .locations .container .map i[data-country="' + country + '"]').removeClass('active');
                $(this).removeClass('active');
          })
    }

    $('.about-page .hero figure').on('click', function(){
        $('.video-overlay').fadeIn(350);
    })

    $('.video-overlay .close').on('click', function(e){
        e.preventDefault();
        // $('.video-overlay').find('video')[0].pause();
        $('.yt_player_iframe').each(function(){
            this.contentWindow.postMessage('{"event":"command","func":"stopVideo","args":""}', '*')
        });
        $('.video-overlay').fadeOut(350);
    })

    $('body').on('click', function(e){
        if($('.video-overlay').length > 0){
            // $('.video-overlay').find('video')[0].pause();
            $('.yt_player_iframe').each(function(){
                this.contentWindow.postMessage('{"event":"command","func":"stopVideo","args":""}', '*')
            });
            if($(e.target).attr('class') === 'video-overlay') $('.video-overlay').fadeOut(350);
        }
    })

    $('.toggle-codes').on('click', function(){
        $(this).toggleClass('expand');
        $(this).siblings('ul').fadeToggle(350);
    })

    $('.countries-codes ul li a').on('click', function(e){
        e.preventDefault();
        $(this).parents('.countries-codes').find('span').text($(this).text());
        $(this).parents('.countries-codes').siblings('input[name="code"]').val($(this).data('value'));
    })

    if($('.countries-codes').length > 0){
        $('body').on('click', function(e){
            if($(e.target).parent().attr('class') !== 'countries-codes'){
                $('.countries-codes ul').fadeOut(350);
                $('.toggle-codes').removeClass('expand');
            }
        })
    }

    $('.submit_form').on('click', function(e){
        e.preventDefault();
        var form = $(this).closest('form');
        var inputs = form.find('input, textarea');
        var return_false = false;
        $(inputs).each(function(){
            if($.trim($(this).val()) === '') {
                $(this).addClass('alert')
                return_false = true;
            } else {
                $(this).removeClass('alert')
            }
        });
        if(return_false === true) {
            return false;
        } else {
            $(form).submit();
        }
    });

    $('.homepage section.header .circle-container').on('mouseenter', function(){
        var circle = $(this).find('.bg');
        var min = -100;
        var max = 100;
        var move_x = Math.floor(Math.random() * (max - min + 1)) + min;
        var move_y = Math.floor(Math.random() * (max - min + 1)) + min;
        var top = parseInt(circle.css('top')) + move_y;
        var left = parseInt(circle.css('top')) + move_x;
        var bottom = parseInt(circle.css('bottom')) + move_y;
        var right = parseInt(circle.css('right')) + move_x;
        if(circle.hasClass('bg-2')) circle.css('bottom', bottom).css('right', right);
        else circle.css('top', top).css('left', left);
    });

    // if($('.homepage section.header .bg').length > 0) {
    //     var lFollowX = 0,
    //         lFollowY = 0,
    //         x = 0,
    //         y = 0,
    //         friction = 1 / 20;
    //
    //     function moveElement() {
    //         x += (lFollowX - x) * friction;
    //         y += (lFollowY - y) * friction;
    //
    //         translate = 'translateX(' + x + 'px) translateY(' + y +'px)';
    //
    //
    //         $('.animate-this').css("-webkit-animation-play-state", "paused").css({
    //             '-webit-transform': translate,
    //             '-moz-transform': translate,
    //             'transform': translate
    //         });
    //
    //         window.requestAnimationFrame(moveElement);
    //     }
    //
    //     $(window).on('mousemove', function(e) {
    //         var isHovered = $('.animate-this:hover').length > 0;
    //
    //         if(!isHovered) {
    //             var lMouseX = Math.max(-100, Math.min(100, $(window).width() / 2 - e.clientX)),
    //                 lMouseY = Math.max(-100, Math.min(100, $(window).height() / 2 - e.clientY));
    //
    //             lFollowX = (100 * lMouseX) / 100;
    //             lFollowY = (50 * lMouseY) / 100;
    //         }
    //     });
    //
    //     moveElement();
    // }

});

$(window).on('load', function(){
    $(".about-page .hero .container-left.preload").removeClass('preload');
});

function isMobile() {
    if($(window).width() <= 960) return true;
    else return false;
}

function carouselNavigationState(carousel){
    if(carousel.find('.slick-prev').hasClass('slick-disabled')) $('.carousel-navigation .prev').addClass('disabled');
    else $('.carousel-navigation .prev').removeClass('disabled');
    if(carousel.find('.slick-next').hasClass('slick-disabled')) $('.carousel-navigation .next').addClass('disabled');
    else $('.carousel-navigation .next').removeClass('disabled');
}

function addAnimationDelayed(container, animation_class, time){
    var index = 0;
    var divs = $(container).children();

    var delay = setInterval(function(){
        if(index <= divs.length){
            $(divs[index]).addClass(animation_class);
            index += 1;
        }else{
            clearInterval(delay);
        }
    }, time);
}