<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\testimonial;

class TestimonialController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $testimonialArr=testimonial::orderBy('testimonial_id','desc')->get();
        return view('admin/testimonials/view',compact('testimonialArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/testimonials/add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $req=new testimonial;
        $req->name=$request->input('txtname');
        $req->title=$request->input('txttitle');
        $req->msg=$request->input('txtmsg');
        if($request->hasfile('txtimg'))
        {
            $var2 = date_create();
            $time2 = date_format($var2, 'YmdHis');
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time2 . '-' .$file->getClientOriginalName();
            $file->move('assets/images/testimonials/', $filename);
            $req->img = $filename;
        }
        $req->save();
        return redirect()->route('testimonials.index')->with('message','Testimonials Upload Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $testimonialArr=testimonial::where('testimonial_id','=',$id)->firstOrFail();
        return view('admin/testimonials/edit',compact('testimonialArr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $req=testimonial::where('testimonial_id','=',$id)->first();
        $req->name=$request->input('txtname');
        $req->title=$request->input('txttitle');
        $req->msg=$request->input('txtmsg');
        if($request->hasfile('txtimg'))
        {
            $var2 = date_create();
            $time2 = date_format($var2, 'YmdHis');
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time2 . '-' .$file->getClientOriginalName();
            $file->move('assets/images/testimonials/', $filename);
            $req->img = $filename;
        }
        $req->save();
        return redirect()->route('testimonials.index')->with('message','Testimonials Update Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        
        testimonial::destroy(array('testimonial_id',$id));
        return redirect()->route('testimonials.index')->with('message','Testimonials Delete Successfully');
    }
}
