<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\service;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $serviceArr = service::orderBy('service_id', 'desc')->get();
        return view('admin/services/view', compact('serviceArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/services/add');

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $var = date_create();
        $time = date_format($var, 'YmdHis');
        
        $req = new service;
        $req->service_name = $request->input('txtname');
        $req->meta_title = $request->input('metatitle');
        $req->meta_description = $request->input('metadescription');
        $req->slug = $request->input('slug');
        $req->service_des = $request->input('txtdes');
        $req->content_one = $request->input('contentOne');
        $req->content_two = $request->input('contentTwo');
        $req->content_three = $request->input('contentThree');


        if ($request->hasfile('txtimg')) {
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' . $file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->service_image = $filename;
        }

        if ($request->hasfile('imageOne')) {
            $file = $request->file('imageOne');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' . $file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_one = $filename;
        }

        if ($request->hasfile('imageTwo')) {
            $file = $request->file('imageTwo');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' . $file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_two = $filename;
        }

        if ($request->hasfile('imageThree')) {
            $file = $request->file('imageThree');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' . $file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_three = $filename;
        }

        $req->save();
        return redirect()->route('services.index')->with('message', 'Service Add Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $servicesArr = service::where('service_id', '=', $id)->firstOrFail();
        return view('admin/services/edit', compact('servicesArr'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $date = date_create();
        $time = date_format($date, 'YmdHis');
        $req = service::where('service_id', '=', $id)->first();
        $req->service_name = $request->input('txtname');
        $req->meta_title = $request->input('metatitle');
        $req->meta_description = $request->input('metadescription');
        $req->slug = $request->input('slug');
        $req->service_des = $request->input('txtdes');
        $req->content_one=$request->input('contentOne');
        $req->content_two=$request->input('contentTwo');
        $req->content_three=$request->input('contentThree');
        if ($request->hasfile('txtimg')) {
            $var2 = date_create();
            $time2 = date_format($var2, 'YmdHis');
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time2 . '-' . $file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->service_image = $filename;
        }
        if($request->hasfile('coverImage'))
        {
            $file = $request->file('coverImage');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->cover_image = $filename;
        }
        if($request->hasfile('imageOne'))
        {
            $file = $request->file('imageOne');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_one = $filename;
        }
        if($request->hasfile('imageTwo'))
        {
            $file = $request->file('imageTwo');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_two = $filename;
        }
        if($request->hasfile('imageThree'))
        {
            $file = $request->file('imageThree');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time . '-' .$file->getClientOriginalName();
            $file->move('assets/images/services/', $filename);
            $req->image_three = $filename;
        }
        $req->save();
        return redirect()->route('services.index')->with('message', 'Services Update Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        service::destroy(array('service_id', $id));
        return redirect()->route('services.index')->with('message', 'Testimonials Delete Successfully');
    }
}
