<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\service;
use App\Models\testimonial;
use App\Models\message;
use App\Models\contact;
use App\Models\portfolio;
use App\Models\portfoliosaddition;
use App\Models\category;
use App\Models\blog;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class FrontController extends Controller
{
    /**
     * Display a listing of the resource.  
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data=testimonial::all();
        $serviceArr=service::all();
        $portfolioArr=portfolio::all();
        $portfolioAdditionArr=portfoliosaddition::all();
        return view('index',compact('serviceArr','portfolioArr','portfolioAdditionArr'))->with('testimonialArr',$data);
    }

    /**
     * Display About Us Page
     */
    public function aboutPage(){
        $data=testimonial::all();
        return view('about')->with('testimonialArr',$data);
    }

    /**
     * Display Contact Us Page
     */
    public function contactPage(){
        $data=service::all();
        $contactArr=contact::all();
        return view('contact',compact('contactArr'))->with('serviceArr',$data);
    }

    /**
     * Display Blog Page
     */
    public function blogPage(){
        $categories = DB::table('categories')->select('cat_id', 'des')->get();
        $blogArr = DB::table('blogs')
                    ->join('categories', 'blogs.category_id', '=', 'categories.cat_id')
                    ->select('blogs.*', 'categories.des as category_name')
                    ->orderBy('blogs.blog_id', 'DESC')
                    ->get();
        return view('blog',compact('blogArr','categories'));
    }


    public function blogDetail($slug)
    {
        $blog = blog::with('category')->where('slug', $slug)->firstOrFail();
        $meta_title = $blog->meta_title;
        $meta_description = Str::limit(strip_tags($blog->meta_description), 160);
        return view('blog-detail', compact('blog','meta_title', 'meta_description'));
    }
    

    /**
     * Display Service Page
     */
    public function servicePage(){
        $serviceArr=service::all();
        $contactArr=contact::all();
        return view('services',compact('serviceArr','contactArr'));
    }

    public function servicesDetailPage($id){
        try {
            $servicesArr = service::where('slug', $id)->firstOrFail();
            return view('servicesDetail', compact('servicesArr'));
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            abort(404);
        }
    }
    


    /**
     * Display Privacy Policy Page
     */
    public function privacyPolicyPage(){
        return view('privacy-policy');
    }
    
    public function moneyBackPolicyPage () {
        return view('money-back-policy');
    }

    /**
     * Display Case Studies Page
     */
    public function caseStudiesPage(){
        $categoryArr=category::all();

        return view('case-studies',compact('categoryArr'));
    }
    /**
     * Display Case Studies Page Detail
     */
    public function caseStudiesDetailPage($id){
        $name = str_replace('-', ' ', $id);
        $portfolioArr=portfolio::where('name','=',$name)->firstOrFail();
        return view('caseStudiesDetail',compact('portfolioArr'));
    }

    public function portfoliosPage(){
        $categoryArr=category::all();

        return view('portfolios',compact('categoryArr'));
    }

    public function portfoliosDetailPage($id){
        $name = str_replace('-', ' ', $id);
        $portfolioAdditionArr=portfoliosaddition::where('name','=',$name)->firstOrFail();
        return view('portfoliosDetail',compact('portfolioAdditionArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $req=new message;
        $req->name=$request->input('name');
        $req->email=$request->input('email');
        $req->code=$request->input('code');
        $req->contact=$request->input('phone');
        $req->msg=$request->input('message');
        if($request->input('services'))
        {
            foreach($request->input('services') as $service)
            {                
                $data[] = $service;  
            }
            $req->services = implode(",", $data);
        }
        
        $req->save();
        return redirect()->route('Thank_you.page')->with('message','Testimonials Upload Successfully');
    }
        public function handle404()
    {
        return response()->view('errors.404',[], 404);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
