<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\blog;
use App\Models\category;


class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $blogArr=blog::orderBy('blog_id','desc')->get();
        return view('admin/blogs/view',compact('blogArr'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categoryArr = category::all();
        return view('admin/blogs/add',compact('categoryArr'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        date_default_timezone_set("Asia/Karachi");
        $date = date('d/m/Y');
        $time = date('h:i:s A');
    
        $req = new Blog;
        $req->title = $request->input('txttitle');
        $req->post = $request->input('txtpost');
        $req->date = $date;
        $req->des = $request->input('txtdes');
        $req->meta_title = $request->input('meta_title');
        $req->meta_description = $request->input('meta_description');
        $req->slug = $request->input('slug');
        $req->category_id = $request->input('category_id'); 
        
        if ($request->hasfile('txtimg')) {
            $var2 = date_create();
            $time2 = date_format($var2, 'YmdHis');
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time2 . '-' . $file->getClientOriginalName();
            $file->move('assets/images/blogs/', $filename);
            $req->img = $filename;
        }
    
        $req->save();
    
        return redirect()->route('blogs.index')->with('message', 'Blog Added Successfully');
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blogArr=blog::where('blog_id','=',$id)->firstOrFail();
        $categories = category::all();
        return view('admin/blogs/edit',compact('blogArr','categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $req=blog::where('blog_id','=',$id)->firstOrFail();
        $req->title=$request->input('txttitle');
        $req->post=$request->input('txtpost');
        $req->des=$request->input('txtdes');
        $req->slug=$request->input('slug');
        $req->meta_title = $request->input('meta_title');
        $req->meta_description = $request->input('meta_description');
        $req->category_id = $request->input('category_id');
        if($request->hasfile('txtimg'))
        {
            $var2 = date_create();
            $time2 = date_format($var2, 'YmdHis');
            $file = $request->file('txtimg');
            $extenstion = $file->getClientOriginalExtension();
            $filename = $time2 . '-' .$file->getClientOriginalName();
            $file->move('assets/images/blogs/', $filename);
            $req->img = $filename;
        }
        $req->save();
        return redirect()->route('blogs.index')->with('message','Blogs Add Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        blog::destroy(array('blog_id',$id));
        return redirect()->route('blogs.index')->with('message','Blogs Delete Successfully');
    }
}
